{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 13.03.98 - 14:51:58 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
{$IFDEF WIN32}
  Windows,
{$ELSE}
  WinTypes,
  WinProcs,
{$ENDIF}
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  MMSystem,
  MMRingBf,
  MMACMCvt,
  MMDSPObj,
  MMTrigg,
  MMWave,
  MMObj,
  MMCstDlg,
  MMDesign,
  MMConect,
  MMGauge,
  MMDIBCv,
  MMSpGram,
  MMHook;
  
type
  TMainForm = class(TForm)
    Connector: TMMConnector;
    MMDesigner1: TMMDesigner;
    Spectrogram: TMMSpectrogram;
    btnStop: TButton;
    btnStart: TButton;
    btnFile: TButton;
    WaveOpenDialog: TMMWaveOpenDialog;
    WaveFile: TMMWaveFile;
    Trigger: TMMTrigger;
    MMPCMConverter1: TMMPCMConverter;
    Gauge: TMMGauge;
    MMRingBuffer1: TMMRingBuffer;
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnFileClick(Sender: TObject);
    procedure TriggerOpen(Sender: TObject);
    procedure TriggerStop(Sender: TObject);
    procedure TriggerBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
    procedure SpectrogramMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure SpectrogramMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ConnectorTrigger(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    ScanLines: PChar;
    MemLines: Longint;
    NumLines: Longint;
    FHeight: integer;
    FBitmap: TBitmap;
  public
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

// This demo saves the output of the spectrogram to a bitmap
// NOTE: The bitmap can be very large !!!

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormCreate(Sender: TObject);
begin
   FHeight := Spectrogram.Height-2*Spectrogram.BevelExtend;

   FBitmap := TBitmap.Create;
   FBitmap.PixelFormat := pf8Bit;
   FBitmap.Height := FHeight;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormDestroy(Sender: TObject);
begin
   FBitmap.Free;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Trigger.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnFileClick(Sender: TObject);
begin
   if WaveOpenDialog.Execute then
   begin
      WaveFile.LoadFromFile(WaveOpenDialog.FileName);
      btnStart.Enabled := True;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnStartClick(Sender: TObject);
begin
   if not WaveFile.Wave.Empty then
   begin
      // we pre-allocate memory for 1000 vertical lines
      NumLines := 0;
      MemLines := 1000;
      GetMem(ScanLines,MemLines*FHeight);

      Trigger.BufferSize := Spectrogram.BytesPerSpectrogram;
      Trigger.Start;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.btnStopClick(Sender: TObject);
begin
   Trigger.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.TriggerOpen(Sender: TObject);
begin
   btnStart.Enabled := False;
   btnStop.Enabled := True;
   btnFile.Enabled := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.TriggerStop(Sender: TObject);
var
   i,j: integer;
begin
   Trigger.Close;
   Gauge.Progress := 0;

   // OK, now it's time to build our bitmap
   Screen.Cursor := crHourGlass;
   FBitmap.Width := NumLines;
   FBitmap.Palette := Spectrogram.DIBCanvas.Palette;
   for i := 0 to FHeight-1 do      // Y
   begin
      for j := 0 to NumLines-1 do  // X
      begin
         PByteArray(FBitmap.ScanLine[i])[j] := PByte(ScanLines+j*FHeight+i)^;
      end;
   end;
   FBitmap.SaveToFile('C:\TEST.BMP');
   Screen.Cursor := crDefault;

   FreeMem(ScanLines);

   btnStart.Enabled := True;
   btnStop.Enabled := False;
   btnFile.Enabled := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.TriggerBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
begin
   Gauge.Progress := Trunc(WaveFile.Wave.Position*100/WaveFile.Wave.DataSize);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.SpectrogramMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   if (trPlay in Trigger.State) then Trigger.Pause;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.SpectrogramMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   if (trPause in Trigger.State) then Trigger.Restart;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TMainForm.ConnectorTrigger(Sender: TObject);
begin
   // OK, the trigger has refreshed the spectrogram, now we can get the
   // next ScanLine

   // do we have enough space ?
   if (NumLines >= MemLines) then
   begin
      inc(MemLines,1000);
      ReAllocMem(ScanLines,MemLines*FHeight);
   end;

   // we need a trick here to see if we have this scanline already in our array
   // the problem is that not every trigger event causes the controls to perform
   // a refresh. The Data in the ColorValues array is no longer required so
   // we use on dword as our column counter, if it has changed then it is a new line
   if (NumLines = 0) or (PLongint(Spectrogram.ColorValues)^ <> NumLines) then
   begin
      // move the last ScanLine to our own buffer
      Move(Spectrogram.ColorValues^,(ScanLines+(NumLines*FHeight))^,FHeight);
      inc(NumLines);
      PLongint(Spectrogram.ColorValues)^ := NumLines;
   end;
end;

end.
